
#ifndef PHYSIQUE_2_AND_3_H
#define PHYSIQUE_2_AND_3_H

class ReMapper;

class PhysiqueHandle
{
public:
    virtual ~PhysiqueHandle() {}

    virtual BonesContainer * GetInfluentialBonesFromPhysique( INode *physiqueNode ) = 0;

    virtual void CalculateCSVertexBoneMap(INode *node, RwInt32 *vertexMap,
        const int CSNumBones, INode ** CSBoneIndexNodePointers,
        ReMapper & remapper,
        RwMatrixWeights  * & skinMatrixWeights, RwUInt32 *  & skinVertexIndices ) = 0;
};

class Physique2Handle : public PhysiqueHandle
{
public:
    BonesContainer * GetInfluentialBonesFromPhysique( INode *physiqueNode );
    void CalculateCSVertexBoneMap(INode *node, RwInt32 *vertexMap,
        const int CSNumBones, INode ** CSBoneIndexNodePointers,
        ReMapper & remapper,
        RwMatrixWeights  * & skinMatrixWeights, RwUInt32 *  & skinVertexIndices );
};

class Physique3Handle : public PhysiqueHandle
{
public:
    BonesContainer * GetInfluentialBonesFromPhysique( INode *physiqueNode );
    void CalculateCSVertexBoneMap(INode *node, RwInt32 *vertexMap,
        const int CSNumBones, INode ** CSBoneIndexNodePointers,
        ReMapper & remapper,
        RwMatrixWeights  * & skinMatrixWeights, RwUInt32 *  & skinVertexIndices );
};

#endif
